/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

/*DRAWBUFFERS:3*/
layout(location = 0) out vec4 data;


#include "/lib/head.glsl"

in vec2 coord;

uniform sampler2D colortex3;
uniform sampler2D colortex6;

uniform sampler2D depthtex0;

uniform float far, near;

uniform vec2 viewSize;

#ifndef ATROUS_SIZE
    #define ATROUS_SIZE 1
#endif


/* ------ includes ------*/
#define FUTIL_LINDEPTH
#include "/lib/fUtil.glsl"

#include "/lib/util/kernel.glsl"
#include "/lib/light/atrousLightmap.glsl"

void main() {
    data   = lightmap3x3(colortex3, depthtex0, colortex6, coord, ATROUS_SIZE);
}